﻿using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.Mappers;
using VA.TMP.Integration.VIMT.Mvi.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.PipelineSteps.PersonSearch
{
    /// <summary>
    /// Create Response step.
    /// </summary>
    public class CreateResponseStep : FilterBase<PersonSearchStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(PersonSearchStateObject state)
        {
            var mapper = new PersonSearchMapper(state);
            if (!string.IsNullOrEmpty(state.PersonSearchFakeResponseType))
            {
                state.PersonSearchResponseMessage = new PersonSearchResponseMessage
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO MVI*****",
                    ExceptionOccured = false,
                    SerializedInstance = string.Empty,
                    RetrieveOrSearchPersonResponse = mapper.MapEcToLOB(state.RetrieveOrSearchPersonResponse)
                };
            }
            else
            {
                state.PersonSearchResponseMessage = state.ExceptionOccured
                    ? new PersonSearchResponseMessage { ExceptionOccured = true, ExceptionMessage = state.ExceptionMessage }
                    : new PersonSearchResponseMessage
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        SerializedInstance = string.Empty,
                        RetrieveOrSearchPersonResponse = mapper.MapEcToLOB(state.RetrieveOrSearchPersonResponse)
                    };
            }
        }
    }
}